﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;

//access resource.resx
using System.Resources;

//our data access class library
using DataAccess;

public class CPatientApptXfer :CData
{
    /// <summary>
    /// US:6005 constructor
    /// </summary>
    /// <param name="data"></param>
    public CPatientApptXfer(CData data)
        : base(data)
    {
        //constructors are not inherited in c#!
    }

    /// <summary>
    /// US:6005 transfer a patient appointment
    /// </summary>
    /// <param name="lXferSystemID"></param>
    /// <param name="strKey"></param>
    /// <param name="WebSession"></param>
    /// <param name="pdi"></param>
    /// <returns></returns>
    public CStatus SavePatientAppointment(long lXferSystemID,
                                          CPatientApptItemXfer pdi)
    {
        //check the patient id
        if (pdi == null || String.IsNullOrEmpty(pdi.ApptID))
        {
            return new CStatus(false, k_STATUS_CODE.Failed, "Could not save appointment, invalid data!"); ;
        }
        
        //check the data connection
        CStatus status = DBConnValid();
        if (!status.Status)
        {
            return status;
        }

        //load the paramaters list
        CDataParameterList pList = new CDataParameterList(SessionID, ClientIP, UserID);

        pList.AddInputParameter("pi_nXferSystemID", lXferSystemID);
        pList.AddInputParameter("pi_nRegionID", this.RegionID);
        pList.AddInputParameter("pi_nSiteID", this.SiteID);
        pList.AddInputParameter("pi_vAppointmentID", pdi.ApptID);
        pList.AddInputParameter("pi_vDFN", pdi.DFN);
        pList.AddInputParameter("pi_nApptClinicID", pdi.ApptClinicID);
        pList.AddInputParameter("pi_nApptSiteID", pdi.ApptSiteID);
        pList.AddInputParameter("pi_vApptCurrentStatus", pdi.ApptCurrentStatus);
        pList.AddInputParameter("pi_vApptPurpose", pdi.ApptPurpose);
        pList.AddInputParameter("pi_vApptStatus", pdi.ApptStatus);
        pList.AddInputParameter("pi_vApptText", pdi.ApptText);
        pList.AddInputParameter("pi_vApptTimeStamp", pdi.ApptTimeStamp);
        pList.AddInputParameter("pi_vApptTitle", pdi.ApptTitle);
        pList.AddInputParameter("pi_vApptType", pdi.ApptType);
        pList.AddInputParameter("pi_vApptVisitID", pdi.ApptVisitID);
      
        //execute the transfer SP
        CStatus statusXfer = DBConn.ExecuteOracleSP("PCK_XFER.XferPatientAppointment", pList);
        if (statusXfer.Status)
        {
            //good to go
        }

        return statusXfer;
    }
}


